//EX 9 Program Title:Determine PIV,Vdc,Idc,Vrms,Pdc and Irms for full Wave bridge Rectifier. 
//environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;
//////////////////////////////////////////////////////////////////
disp('For Full Wave Bridge Rectifier Analysis:' );
RL=input('Enter the value of Load Resistance in Ohms       RL:');//Note:Press enter
Vac=input('Enter the value of Input AC Voltage in Volts     Vac:');//Note:Press enter
N1=input('Enter the Number of primary turns in trun ratio    N1:');//Note:Press enter/
N2=input('Enter the Number of Secondary turns in trun ratio N2:');//Note:Press enter/
mprintf('\n. \********************************************\');
//////////////////////////////////////////////////////////////////
disp('Given data for Full Wave Bridge Rectifier circuit is:' );
mprintf(' Load Resistance            RL:%2d ohm',RL);
mprintf('\n Input AC voltage           V1:%2d V',Vac);
mprintf('\n Number of Secondary turns  N2:%1d ',N2);
mprintf('\n Number of Primary turns    N1:%1d ',N1);
mprintf('\n');
//////////////////Voltage at Secondary//////////////////////////////////
mprintf('\n. \***********Solution************************************\');
V2=Vac*(N2/N1); // calculation of RMS secondary
mprintf('\n 1)Voltage at Secondary is                        V2:%1dV',V2);
/////////////////Maximum Value at Secondary //////////////////////////////
mprintf('\n. \*****************************************************\');
Vrms=V2; //Volt Maxi voltage across secondary
mprintf('\n 2)Maximum value of secondary voltage is          Vrms:%.1fV ',Vrms);
mprintf('\n. \*****************************************************\');
Vm=Vrms*sqrt(2); //Volt peak value of output
mprintf('\n 3)Maximum voltage value of secondary Winding is  Vm:%.1fV ',Vm);
mprintf('\n. \*****************************************************\');
//////////////Load Current//////////////////////////////////
Im=Vm/RL;   // Amperes peak value of output current
mprintf('\n 4)Maxi.value of load Current is                  Im:%.2fA',Im);
mprintf('\n. \*****************************************************\');
Idc=(2*Vm)/(3.14*RL);    //Amperes Load current
//Idc=Idc*1e3;  //mili amperes//
mprintf('\n 5)Average value of Load current is               Idc:%.2f A',Idc);
mprintf('\n. \*****************************************************\');
Vdc=Idc*RL;   //Volts  Output DC voltage
mprintf('\n 6)Average Value of Output Voltage is             Vdc:%2dV',Vdc);
mprintf('\n. \*****************************************************\');
Pdc=(Idc^2)*RL;    // Watts Average Power
mprintf('\n 7)Average Value Of load Power is                 Pdc:%.1fW',Pdc);
mprintf('\n. \*****************************************************\');
PIV=2*Vm;   //Volts  peak inverse voltage
mprintf('\n 8)Peak Inverse Voltage is                        PIV:%1dV',PIV);
mprintf('\n. \*****************************************************\');
Irms=0.707*(Vm/RL);    //Amperes RMS Value of Current
Irms=Irms*1e3;  // mili amperes
mprintf('\n 9)RMS Value of  current is                       Irms:%.1fA',Irms);
mprintf('\n. \*****************************************************\');


//output//
  
 //For Full Wave Bridge Rectifier Analysis:   
//Enter the value of Load Resistance in Ohms       RL:200
//Enter the value of Input AC Voltage in Volts     Vac:230
//Enter the Number of primary turns in trun ratio    N1:4
//Enter the Number of Secondary turns in trun ratio N2:1

//. ******************************************** 
// Given data for Full Wave Bridge Rectifier circuit is:   
//Load Resistance            RL:200 ohm
//Input AC voltage           V1:230 V
// Number of Secondary turns  N2:1 
//Number of Primary turns    N1:4 
//. ***********Solution************************************
// 1)Voltage at Secondary is                        V2:57V
//. *****************************************************
//2)Maximum value of secondary voltage is          Vrms:57.5V 
//. *****************************************************
// 3)Maximum voltage value of secondary Winding is  Vm:81.3V 
//. *****************************************************
// 4)Maxi.value of load Current is                  Im:0.41A
//. *****************************************************
// 5)Average value of Load current is               Idc:0.26 A
//. *****************************************************
 //6)Average Value of Output Voltage is             Vdc:51V
//. *****************************************************
// 7)Average Value Of load Power is                 Pdc:13.4W
//. *****************************************************
// 8)Peak Inverse Voltage is                        PIV:162V
//. *****************************************************
// 9)RMS Value of  current is                       Irms:287.5A
//. *****************************************************
